﻿
/****** Object:  StoredProcedure [hips].[MonitoringPcehrConnectionFailure]    Script Date: 07/11/2013 12:24:52 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitoringPcehrConnectionFailure]') AND type in (N'P', N'PC'))
DROP PROCEDURE [hips].[MonitoringPcehrConnectionFailure]
GO

/****** Object:  StoredProcedure [hips].[MonitoringPcehrConnectionFailure]    Script Date: 07/11/2013 12:24:52 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Create date:   2013
-- Description:   Gets Pcehr % of connection failure in the timeframe specified
-- =============================================
Create PROCEDURE [hips].[MonitoringPcehrConnectionFailure] 
(
	@Minutes Integer 
)
AS
BEGIN
	
	DECLARE @pcehrRequests INT, @pcehrConnectionFailures INT

	SELECT @pcehrRequests = COUNT(*) 		
		FROM  hips.PcehrAudit s WITH (NOLOCK)
		where 
			DateCreated >= DATEADD(minute, @Minutes * -1, SYSDATETIME())

	SELECT @pcehrConnectionFailures = COUNT(*)	
		FROM hips.[MonitoringSyslog]
		WHERE MonitorTabId = 5
		AND 
			DateCreated >= DATEADD(minute, @Minutes * -1, SYSDATETIME())


	IF (@pcehrRequests = 0)
	BEGIN
		SELECT 0.0
	END
	ELSE
	BEGIN
		SELECT  CAST(ROUND(((@pcehrConnectionFailures)*1.0/@pcehrRequests*1.0)*100,1,1) AS DECIMAL(6,1)) AS PercentageSuccess
	END

END

GO